<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title><?php echo e($gnl->title); ?> | <?php echo e($gnl->subtitle); ?> </title>
        <!--Favicon add-->
        <link rel="shortcut icon" type="image/png" href="<?php echo e(asset('assets/images/logo/icon.png')); ?>">
        <!--bootstrap Css-->
        <link href="<?php echo e(asset('assets/app/css/bootstrap.min.css')); ?>" rel="stylesheet">
        <!--font-awesome Css-->
        <link href="<?php echo e(asset('assets/app/css/font-awesome.min.css')); ?>" rel="stylesheet">
        <!--owl.carousel Css-->
        <link href="<?php echo e(asset('assets/app/css/owl.carousel.min.css')); ?>" rel="stylesheet">
        <!--Slick Nav Css-->
        <link href="<?php echo e(asset('assets/app/css/slicknav.min.css')); ?>" rel="stylesheet">
        <!--Animate Css-->
        <link href="<?php echo e(asset('assets/app/css/animate.css')); ?>" rel="stylesheet">
        <!--Magnitic popup Css-->
        <link href="<?php echo e(asset('assets/app/css/magnific-popup.css')); ?>" rel="stylesheet">
        <!--Style Css-->
        <link href="<?php echo e(asset('assets/app/css/style.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('assets/app/css/color.css')); ?>" rel="stylesheet">
              <link href="<?php echo e(asset('assets/app/css/color.php?color=')); ?><?php echo e($gnl->color); ?>" rel="stylesheet">
        <!--Responsive Css-->
        <link href="<?php echo e(asset('assets/app/css/responsive.css')); ?>" rel="stylesheet">
            <script src="<?php echo e(asset('assets/admin/global/plugins/jquery.min.js')); ?>" type="text/javascript"></script>
          <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.css">
    	<script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>
    </head>
    <body>
	
    <!--navbar area start-->
    <nav class="navbar-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-3 ">
                    <a href="<?php echo e(url('/')); ?>" class="logo"><img src="<?php echo e(asset('assets/images/logo/logo.png')); ?>" alt="logo image"></a>
                </div>   
                <div class="col-lg-9 text-right ">     
                    <ul id="main-menu" >
                        <?php if(auth()->guard()->check()): ?>
                        <li><a href="<?php echo e(route('home')); ?>"><?php echo e(Auth::user()->name); ?></a></li>
                         <li>
					        <a href="<?php echo e(route('logout')); ?>"
					        onclick="event.preventDefault();
					        document.getElementById('logout-form').submit();"><i class="fa fa-sign-out" aria-hidden="true"></i>
					        <span>SIGN OUT</span>
					      </a>

					      <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
					        <?php echo e(csrf_field()); ?>

					      </form>
					    </li>
                        <?php else: ?>
                        <li><a href="<?php echo e(route('login')); ?>">Sign In</a></li>
                        <li><a href="<?php echo e(route('register')); ?>">Sign Up</a></li>
                        <?php endif; ?>
                    </ul>
                </div>   
            </div>
        </div>
    </nav>
<?php $front = \App\Frontend::first(); ?>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('layouts.alert', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<footer class="footer-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 col-md-7">
                <p class="copyright-text"><?php echo $front->footer1; ?></p>
            </div>
        </div>
    </div>
</footer>
<!--footer section end-->

<!--preloader start-->
<div class="preloader">
    <div class="preloader-wrapper">
        <div class="preloader-img">
            <img src="<?php echo e(asset('assets/images/logo/icon.png')); ?>" alt="*">
        </div>
    </div>
</div>
<!--preloader end-->

    <!--back to top start-->
    <div class="back-to-top">
        <i class="fa fa-angle-up"></i>
    </div>
    <!--back to top end-->
	    <!--jquery script load-->
        <script src="<?php echo e(asset('assets/app/js/jquery.js')); ?>"></script>
        <!--Owl carousel script load-->
		<script src="<?php echo e(asset('assets/app/js/owl.carousel.min.js')); ?>"></script>
        <!--Propper script load here-->
        <script src="<?php echo e(asset('assets/app/js/popper.min.js')); ?>"></script>
        <!--Bootstrap v4 script load here-->
        <script src="<?php echo e(asset('assets/app/js/bootstrap.min.js')); ?>"></script>
        <!--Slick Nav Js File Load-->
        <script src="<?php echo e(asset('assets/app/js/jquery.slicknav.min.js')); ?>"></script>
        <!--Scroll Spy File Load-->
        <script src="<?php echo e(asset('assets/app/js/scrollspy.min.js')); ?>"></script>
        <!--Wow Js File Load-->
        <script src="<?php echo e(asset('assets/app/js/wow.min.js')); ?>"></script>
        <!--Magnific popup Js File Load-->
        <script src="<?php echo e(asset('assets/app/js/jquery.magnific-popup.js')); ?>"></script>
        <!--Main js file load-->
        <script src="<?php echo e(asset('assets/app/js/main.js')); ?>"></script>

        <script type="text/javascript">
            var SlicMenu = $('#main-menu');
            SlicMenu.slicknav();

                var winHeight = $(window).height();
                    $('#contact').css({
                        'min-height':winHeight,
                    });
        </script>

    </body>
</html>
